<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0.0">

	<!-- Дата из формата YYYY-MM-DD в формат DD month YYYY -->
	<xsl:template name="ДатаПрописью">
		<xsl:param name="Дата" select="''"/>
		<xsl:choose>
			<xsl:when test="(string-length($Дата) = 10) and (substring($Дата, 5, 1) = '-') and (substring($Дата, 8, 1) = '-')">
  			<xsl:value-of select="concat(substring($Дата, 9, 2), '&#160;')"/>
    		<xsl:variable name="Месяц" select="substring($Дата, 6, 2)"/>
        <xsl:choose>
          <xsl:when test="$Месяц = '01'">января</xsl:when>
          <xsl:when test="$Месяц = '02'">февраля</xsl:when>
          <xsl:when test="$Месяц = '03'">марта</xsl:when>
          <xsl:when test="$Месяц = '04'">апреля</xsl:when>
          <xsl:when test="$Месяц = '05'">мая</xsl:when>
          <xsl:when test="$Месяц = '06'">июня</xsl:when>
          <xsl:when test="$Месяц = '07'">июля</xsl:when>
          <xsl:when test="$Месяц = '08'">августа</xsl:when>
          <xsl:when test="$Месяц = '09'">сентября</xsl:when>
          <xsl:when test="$Месяц = '10'">октября</xsl:when>
          <xsl:when test="$Месяц = '11'">ноября</xsl:when>
          <xsl:when test="$Месяц = '12'">декабря</xsl:when>
        </xsl:choose>
  			<xsl:value-of select="concat('&#160;', substring($Дата, 1, 4))"/>
			</xsl:when>
			<xsl:otherwise>
  			<xsl:text>[неизвестно]</xsl:text>
			</xsl:otherwise>
		</xsl:choose>				
	</xsl:template>

	<!-- Дата из формата YYYY-MM-DD в формат DD.MM.YYYY -->
	<xsl:template name="ДатаЧислами">
		<xsl:param name="Дата" select="''"/>
		<xsl:choose>
			<xsl:when test="(string-length($Дата) = 10) and (substring($Дата, 5, 1) = '-') and (substring($Дата, 8, 1) = '-')">
  			<xsl:value-of select="concat(substring($Дата, 9, 2), '.', substring($Дата, 6, 2), '.', substring($Дата, 1, 4))"/>
			</xsl:when>
			<xsl:otherwise>
  			<xsl:text>[неизвестно]</xsl:text>
			</xsl:otherwise>
		</xsl:choose>				
	</xsl:template>

</xsl:stylesheet>
