<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0.0">

  <!-- Титул документа -->
  <xsl:template name="ТитулДокумента">
    <xsl:text>ГосЭДО: </xsl:text>
    <xsl:value-of select="/*[local-name()='Документ']/*[local-name()='ДанныеДокумента']/*[local-name()='ЗаголовокДокумента']/@*[local-name()='ВидНазвание']"/>
  </xsl:template>

  <!-- Заголовок документа -->
  <xsl:template mode="ЗаголовокДокумента" match="*[local-name()='Документ']">
    <!-- Документ ГосЭДО должен содержать ровно один ЗаголовокДокумента -->
    <xsl:for-each select="./*[local-name()='ДанныеДокумента']/*[local-name()='ЗаголовокДокумента']">
      <div class="textHeader1">
        ГосЭДО: <xsl:value-of select="./@*[local-name()='ВидНазвание']"/>
      </div>
      <table width="100%">
        <tr>
          <td width="70%">
            <table width="100%">
              <tr class="textBold">
                <td width="20%">Автор</td>
                <td width="80%">
                  <xsl:value-of select="./*[local-name()='СсылкаСоздателя']/@*[local-name()='Представление']"/>
                </td>
              </tr>
              <tr>
                <td width="20%">Номер</td>
                <td width="80%" class="textCode">
                  <xsl:value-of select="./*[local-name()='СсылкаДокумента']/@*[local-name()='ДокументУУИД']"/>
                </td>
              </tr>
              <tr>
                <td width="20%">Создан</td>
                <td width="80%" class="textCode">
                  <xsl:call-template name="ДатаЧислами">
                    <xsl:with-param name="Дата" select="substring-before(./*[local-name()='ВремяСоздания'], 'T')"/>
                  </xsl:call-template>
                  <xsl:text> в </xsl:text>
                  <xsl:value-of select="substring-after(./*[local-name()='ВремяСоздания'], 'T')"/>
                </td>
              </tr>
            </table>
          </td>
          <xsl:if test="./*[local-name()='СодержитСведенияДСП']='Да'">
            <td width="10%"/>
            <td width="20%">
              <xsl:call-template name="ПометкаДСП"/>
            </td>
          </xsl:if>
        </tr>
      </table>
      <br/>
    </xsl:for-each>
  </xsl:template>

  <!-- Заголовок документа: Пометка ДСП -->
  <xsl:template name="ПометкаДСП">
    <style>
      <xsl:text>
  .dsp 
  {
    border: 2pt solid;
    border-color: red;
    color: red;
  }
  .dsp-row
  {
    display: grid;
  }
  .dsp-title
  {
    font-family: "Arial Narrow", "Helvetica Narrow", sans-serif;
    font-weight: bold;
    text-align: center;
  }
      </xsl:text>
    </style>
    <table class="dsp">
      <tr class="dsp-row">
        <td class="dsp-title">
          ДЛЯ&#160;СЛУЖЕБНОГО<br/>ПОЛЬЗОВАНИЯ
        </td>
      </tr>
    </table>
  </xsl:template>

  <!-- Сообщения документа -->
  <xsl:template mode="СообщенияДокумента" match="*[local-name()='Документ']">
    <!-- Документ ГосЭДО может содержать несколько событий внутри СообщенияДокумента -->
    <xsl:for-each select="./*[local-name()='ДанныеДокумента']/*[local-name()='СообщенияДокумента']/*">
      <div class="textHeader2">
        <xsl:value-of select="./*[local-name()='ИнформацияОСобытии']/@*[local-name()='ВидНазвание']"/>
      </div>
      <table width="100%">
        <tr>
          <td width="15%">Процесс</td>
          <td width="85%" class="textCode">
            <xsl:value-of select="./*[local-name()='ИнформацияОПроцессе']/*[local-name()='СсылкаПроцесса']/@*[local-name()='ПроцессУУИД']"/>
          </td>
        </tr>
        <tr>
          <td width="15%">Событие</td>
          <td width="85%" class="textCode">
            <xsl:value-of select="./*[local-name()='ИнформацияОСобытии']/*[local-name()='СсылкаСобытия']/@*[local-name()='СобытиеУУИД']"/>
          </td>
        </tr>
      </table>

      <!-- Корреспонденты -->
      <xsl:if test="./*[local-name()='АгентыСобытия']/*[local-name()='АгентыПолучатели']/*">
        <div class="textHeader3">
          <xsl:text>Корреспонденты:</xsl:text>
        </div>
        <div class="textPadding">
          <xsl:for-each select="./*[local-name()='АгентыСобытия']/*[local-name()='АгентыПолучатели']/*">
            <div>
              <xsl:value-of select="./@*[local-name()='ВидНазвание']"/>
              <xsl:text>: </xsl:text>
              <xsl:value-of select="./*[local-name()='СсылкаАгента']/@*[local-name()='Представление']"/>
            </div>
          </xsl:for-each>
        </div>
      </xsl:if>

      <!-- Предметы -->
      <xsl:for-each select="./*[local-name()='ПредметыСобытия']/*">
        <div class="textHeader3">
          <xsl:value-of select="./@*[local-name()='ВидНазвание']"/>
          <xsl:if test="./*[local-name()='СостояниеПредмета']">
            <xsl:text>: </xsl:text>
            <xsl:value-of select="./*[local-name()='СостояниеПредмета']"/>
          </xsl:if>
        </div>
        <div>
          <xsl:apply-templates select="./*[local-name()='ДанныеДляВизуализации']/*" mode="Рекурсивно"/>
          <xsl:apply-templates select="./*[local-name()='ДанныеДляКоординации']/*" mode="Рекурсивно"/>
        </div>
      </xsl:for-each>
      <br/>
    </xsl:for-each>
  </xsl:template>

  <!-- Рекурсивный вывод любой ноды или атрибута -->
  <xsl:template match="@*|node()" mode="Рекурсивно">
    <div class="textPadding">
      <xsl:value-of select="local-name(.)"/>
      <xsl:text>: </xsl:text>
      <xsl:choose>
        <xsl:when test="(count(*) = 0) and (count(@*) = 0)">
          <xsl:value-of select="."/>
        </xsl:when>
        <!-- Особый вывод для СсылкаСВидомСправочника -->
        <xsl:when test="(count(*) = 1) and (count(@*) = 2) and (count(./*[local-name()='СсылкаСправочника']) = 1)">
          <xsl:for-each select="./*[local-name()='СсылкаСправочника']">
            <xsl:value-of select="@*[local-name()='ИД']"/>
            <xsl:text> «</xsl:text>
            <xsl:value-of select="@*[local-name()='Название']"/>
            <xsl:text>» </xsl:text>
          </xsl:for-each>
        </xsl:when>
        <!-- Прямой вывод атрибутов, рекурсивный вывод элементов -->
        <xsl:otherwise>
          <xsl:for-each select="./@*">
            <xsl:value-of select="local-name(.)"/>
            <xsl:text> «</xsl:text>
            <xsl:value-of select="."/>
            <xsl:text>» </xsl:text>
          </xsl:for-each>
          <xsl:apply-templates select="./*" mode="Рекурсивно"/>
        </xsl:otherwise>
      </xsl:choose>
    </div>
  </xsl:template>

  <!-- Приложения документа -->
  <xsl:template mode="ПриложенияДокумента" match="*[local-name()='Документ']">
    <!-- Документ ГосЭДО может содержать несколько приложений внутри ПриложенияДокумента -->
    <xsl:for-each select="./*[local-name()='ДанныеДокумента']/*[local-name()='ПриложенияДокумента']">
      <div class="textHeader2">
        <xsl:text>Приложения</xsl:text>
      </div>
      <xsl:for-each select="./*">
        <div class="textPadding">
          <xsl:value-of select="count(preceding-sibling::*)+1"/>
          <xsl:text>. </xsl:text>
          <xsl:value-of select=".//*[local-name()='Описание']"/>
          <xsl:text> (</xsl:text>
          <xsl:value-of select=".//*[local-name()='ИмяФайла']"/>
          <xsl:text>)</xsl:text>
        </div>
      </xsl:for-each>
      <br/>
    </xsl:for-each>
  </xsl:template>

  <!-- Стиль типовой визуализации документа -->
  <xsl:template name="СтильДокумента">
    <style>
      <xsl:text>
  body
  {
    font-family: Arial, Helvetica, sans-serif;
    font-style: normal;
    font-size: medium;
    line-height: 1.4;
    hyphens: auto;
  }
  .textHeader1
  {
    font-weight: bold;
    font-size: xx-large;
  }
  .textHeader2
  {
    font-weight: bold;
    font-size: x-large;
  }
  .textHeader3
  {
    font-weight: bold;
    font-size: medium;
    line-height: 2;
  }
  .textCode
  {
    font-family: Courier, monospace;
  }
  .textBold
  {
    font-weight: bold;
  }
  .textPadding
  {
    margin-left: 1em;
  }
  .textAttention
  {
    color: dodgerblue;
  }
  .textInformation
  {
    color: green;
  }
  .textWarning
  {
    color: red;
  }
      </xsl:text>
    </style>
  </xsl:template>

</xsl:stylesheet>
