<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0.0">

  <!-- Подписи документа -->
  <xsl:template mode="ПодписиДокумента" match="*[local-name()='Документ']">
    <xsl:variable name="ТребуетПодписания" select="./*[local-name()='ДанныеДокумента']
      /*[local-name()='ЗаголовокДокумента']
      /*[local-name()='ТребуетПодписания']"/>

    <xsl:if test="($ТребуетПодписания='Да') or (./*[local-name()='ПодписиДокумента'])">
      <div class="textAttention textHeader2">
        <xsl:text>Подписи:</xsl:text>
      </div>
      <xsl:choose>
        <xsl:when test="./*[local-name()='ПодписиДокумента']/*[local-name()='ПодписьДокумента']">
          <div class="stamps">
            <xsl:call-template name="СтильПодписьДокумента"/>
            <xsl:apply-templates select="./*[local-name()='ПодписиДокумента']/*[local-name()='ПодписьДокумента']"/>
          </div>
        </xsl:when>
        <xsl:otherwise>
          <div class="textInformation">
            <xsl:text>Документ ещё не подписан</xsl:text>
          </div>
        </xsl:otherwise>
      </xsl:choose>
      <br/>
    </xsl:if>
  </xsl:template>

  <!-- Подпись документа -->
  <xsl:template match="*[local-name()='ПодписьДокумента']">
    <table class="stamp">
      <tr class="stamp-row">
        <td class="stamp-image"/>
        <td class="stamp-title">Документ подписан<br/>электронной подписью</td>
      </tr>
      <tr class="stamp-row">
        <td>Владелец</td>
        <td>
          <xsl:value-of select="(.//*[local-name()='ДанныеДержателя'])/*[local-name()='Фамилия']"/>
          <xsl:text> </xsl:text>
          <xsl:value-of select="(.//*[local-name()='ДанныеДержателя'])/*[local-name()='ИмяОтчество']"/>
        </td>
      </tr>
      <tr class="stamp-row">
        <td>Сертификат</td>
        <td>
          <xsl:value-of select="(.//*[local-name()='СерийныйНомер'])"/>
        </td>
      </tr>
      <tr class="stamp-row">
        <td>Действителен</td>
        <td>
          <xsl:text>с </xsl:text>
          <xsl:call-template name="ДатаЧислами">
            <xsl:with-param name="Дата" select="(.//*[local-name()='ДатаНачала'])"/>
          </xsl:call-template>
          <xsl:text> по </xsl:text>
          <xsl:call-template name="ДатаЧислами">
            <xsl:with-param name="Дата" select="(.//*[local-name()='ДатаОкончания'])"/>
          </xsl:call-template>
        </td>
      </tr>
    </table>
  </xsl:template>

  <!-- Стили визуализации подписи документа (штампа ЭП) -->
  <xsl:template name="СтильПодписьДокумента">
    <style>
      <xsl:text>
  .stamp 
  {
    border: 2pt solid;
    border-radius: 12pt;
    border-color: dodgerblue;
    color: dodgerblue;
    font-family: Arial, Helvetica, sans-serif;
    font-style: normal;
    font-size: small;
    hyphens: auto;
    line-height: 1.25;
    margin-bottom: 1em;
    max-width: 280pt;
    padding: 0.5em;
  }
  .stamp-row
  {
    display: grid;
    grid-template-columns: 13ch auto;
    padding: 0 0.5em;
  }
  .stamp-image
  {
    width: 35pt;
    height: 40pt;
    background-repeat: no-repeat;
    background-image: url("data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' fill='dodgerblue' width='45' height='50' viewBox='0 0 29 30'%3E%3Cpath d='M19.84615,9.88329508 C19.3927833,9.48585246 18.7407667,9.49488525 18.3666667,9.61040984 C18.6117167,9.30947541 19.1825333,9.0627377 19.3507333,9.03278689 C19.4788167,9.08080328 19.84615,9.45827869 19.84615,9.88329508 Z M21.2937333,8.23742623 C20.9955167,6.64242623 17.2888333,7.6992623 15.4222,7.02180328 C15.3864333,7.4867541 15.9968833,8.23172131 16.58075,8.50745902 C15.5826667,9.37365574 14.6865667,11.1188852 14.5058,13.2510984 C14.3255167,11.1188852 13.4294167,9.37365574 12.4313333,8.50745902 C13.0152,8.23172131 13.6261333,7.4867541 13.5898833,7.02180328 C11.72325,7.6992623 8.01656667,6.64242623 7.71786667,8.23742623 C7.65503333,8.57496721 7.81743333,9.08936066 7.99288333,9.23721311 C8.0243,9.1302459 8.18815,8.78034426 8.70483333,8.70190164 C11.3162833,8.30731148 13.4966,12.3321311 11.5284667,13.959459 C11.4985,13.9841803 11.5154167,14.0298197 11.5560167,14.0298197 L17.45655,14.0298197 C17.4966667,14.0298197 17.5135833,13.9841803 17.4841,13.959459 C15.5154833,12.3321311 17.6958,8.30731148 20.30725,8.70190164 C20.8244167,8.78034426 20.9877833,9.1302459 21.0192,9.23721311 C21.19465,9.08936066 21.35705,8.57496721 21.2937333,8.23742623 Z M21.9288333,4.57677049 C21.88195,4.42606557 23.41315,4.4222623 23.41315,5.38068852 C23.41315,6.02296721 22.4972333,6.32722951 22.4972333,6.9937541 C22.4972333,7.30419672 22.8312167,7.53191803 22.9336833,7.53191803 C22.6978167,6.46177049 23.6731833,7.02180328 23.9366,7.22195082 C23.41315,5.78288525 24.5915167,5.79191803 24.4755167,5.13204918 C24.3948,4.67090164 23.3706167,4.81019672 22.9999,4.57677049 C22.3420833,4.16268852 21.5639167,2.55152459 21.0511,4.16268852 C22.0071333,5.05027869 21.4508167,6.35670492 20.2371667,6.35670492 C20.2371667,6.35670492 20.2304,6.54829508 20.2415167,6.5635082 C21.6891,6.49267213 22.1937,5.42870492 21.9288333,4.57677049 Z M5.0402,7.22195082 C5.30361667,7.02180328 6.27898333,6.46177049 6.0436,7.53191803 C6.14558333,7.53191803 6.47956667,7.30419672 6.47956667,6.9937541 C6.47956667,6.32722951 5.56365,6.02296721 5.56365,5.38068852 C5.56365,4.4222623 7.09485,4.42606557 7.04796667,4.57677049 C6.78358333,5.42870492 7.28818333,6.49267213 8.73576667,6.5635082 C8.7464,6.54829508 8.73963333,6.35670492 8.73963333,6.35670492 C7.52646667,6.35670492 6.97015,5.05027869 7.9257,4.16268852 C7.41288333,2.55152459 6.63471667,4.16268852 5.9769,4.57677049 C5.60618333,4.81019672 4.582,4.67090164 4.50128333,5.13204918 C4.38576667,5.79191803 5.56365,5.78288525 5.0402,7.22195082 Z M9.15046667,9.88329508 C9.60431667,9.48585246 10.2563333,9.49488525 10.62995,9.61040984 C10.3858667,9.30947541 9.81408333,9.0627377 9.64636667,9.03278689 C9.51828333,9.08080328 9.15046667,9.45827869 9.15046667,9.88329508 Z M15.19455,0.961278689 L14.4884,0.100311475 L13.78225,0.961278689 L14.4884,1.86740984 L15.19455,0.961278689 Z M19.22555,3.56462295 L18.7233667,2.95277049 L18.2216667,3.56462295 L18.7233667,4.16268852 L19.22555,3.56462295 Z M23.2986,21.2508197 L22.66205,20.5771639 L22.0255,21.2508197 L22.66205,21.8417541 L23.2986,21.2508197 Z M10.7556167,3.56462295 L10.2534333,2.95277049 L9.75173333,3.56462295 L10.2534333,4.16268852 L10.7556167,3.56462295 Z M9.31721667,6.5635082 L11.1901333,6.5635082 C12.7648333,6.5635082 13.4734,5.597 13.6875167,4.75885246 L15.2897667,4.75885246 C15.5038833,5.597 16.2119667,6.5635082 17.78715,6.5635082 L19.6600667,6.5635082 C19.6600667,6.5635082 19.9877667,6.119 20.0699333,5.89888525 C20.3657333,5.10685246 19.9877667,4.73745902 19.4362833,4.73745902 L18.7233667,5.38354098 L18.01045,4.73745902 C17.4589667,4.73745902 17.081,5.10685246 17.3768,5.89888525 C17.4145,6.00014754 17.5048833,6.14895082 17.5904333,6.27968852 C16.92585,6.18840984 16.0776,5.73344262 15.8915167,4.75885246 C15.8915167,4.75885246 16.3825833,3.97870492 16.5058333,3.66303279 C16.9485667,2.5277541 16.3830667,2.0637541 15.5560833,2.0637541 L14.4884,3.31883607 L13.4207167,2.0637541 C12.5937333,2.0637541 12.0282333,2.5277541 12.47145,3.66303279 C12.5942167,3.97870492 13.0857667,4.75885246 13.0857667,4.75885246 C12.8992,5.73344262 12.05095,6.18840984 11.3863667,6.27968852 C11.4724,6.14895082 11.5623,6.00014754 11.6,5.89888525 C11.8953167,5.10685246 11.5183167,4.73745902 10.96635,4.73745902 L10.2534333,5.38354098 L9.54051667,4.73745902 C8.98855,4.73745902 8.61155,5.10685246 8.90686667,5.89888525 C8.98903333,6.119 9.31721667,6.5635082 9.31721667,6.5635082 Z M28.681,12.3692131 C28.3194667,12.5522459 26.1986,13.5458525 23.4817833,13.1783607 C23.5103,13.0485738 23.5335,12.9178361 23.5533167,12.7870984 C25.3614667,12.5707869 26.8312833,12.2641475 27.7679833,11.7430984 C28.8356667,11.1488361 29.3025667,9.73021311 28.76365,8.67480328 C28.7496333,8.64818033 28.7109667,8.64342623 28.6916333,8.66577049 C28.3963167,9.00568852 26.53935,11.0257049 23.6137333,11.6537213 C23.606,11.5011148 23.5924667,11.3504098 23.5721667,11.2006557 C24.9931667,10.3948361 26.3803333,9.46636066 27.04105,8.61727869 C28.0396167,7.33367213 27.9477833,5.69636066 26.99755,4.86154098 C26.97725,4.84347541 26.9443833,4.84870492 26.9303667,4.87104918 C26.6297333,5.36690164 23.8157667,9.91514754 20.7263,11.8785902 C20.6953667,11.8985574 20.6538,11.9242295 20.6122333,11.9494262 C20.5237833,12.0031475 20.5141167,12.1181967 20.5895167,12.1866557 C20.9457333,12.509459 21.1671,12.9587213 21.1671,13.4574262 C21.1671,14.3245738 20.49865,15.0457705 19.6151167,15.2021803 C19.1661,15.2891803 18.51795,15.2639836 17.8954167,15.0581311 C17.8673833,15.0490984 17.8383833,15.0676393 17.8383833,15.0956885 L17.8383833,17.8421311 C17.8383833,17.8863443 17.9055667,17.8972787 17.9215167,17.8549672 C18.2999667,16.8523279 19.4329,16.6393443 19.9283167,16.6393443 C20.1066667,17.710918 20.4251833,18.5985082 20.8389167,19.0762951 C21.5126833,19.8526393 22.61275,19.8417049 23.0898,19.3049672 C23.1062333,19.2864262 23.1014,19.2574262 23.0791667,19.2450656 C22.7988333,19.0839016 21.1951333,18.0993279 20.8742,16.4857869 C21.0008333,16.4420492 21.1245667,16.3926066 21.2429833,16.3341311 C21.7606333,17.1908197 22.51415,17.9538525 23.1207333,18.2452787 C24.1396,18.734 25.0724333,18.4962951 25.4861667,17.7808033 C25.50115,17.7556066 25.4827833,17.7242295 25.4523333,17.721377 C24.8220667,17.6709836 22.8877667,17.1166557 22.0641667,15.7660164 C22.1584167,15.6794918 22.2507333,15.5891639 22.3367667,15.4931311 C23.19855,16.1491967 24.4170333,16.7291967 25.28945,16.8475738 C26.31025,16.9863934 27.4668667,16.6607377 27.4949,15.4736393 C27.4953833,15.4498689 27.4741167,15.430377 27.4489833,15.4318033 C27.086,15.4536721 24.68335,15.5582623 22.9713833,14.5755902 C23.0308333,14.462918 23.0859333,14.3478689 23.13765,14.2304426 C23.13765,14.2304426 25.72445,14.8418197 26.9501833,14.6392951 C28.1681833,14.4381967 28.8815833,13.5301639 28.7438333,12.4005902 C28.7399667,12.372541 28.7071,12.3559016 28.681,12.3692131 Z M5.83915,14.2304426 C5.89086667,14.3478689 5.94645,14.462918 6.0059,14.5755902 C4.29441667,15.5577869 1.89273333,15.4541475 1.5283,15.4318033 C1.50268333,15.430377 1.48141667,15.4508197 1.4819,15.4741148 C1.51041667,16.6607377 2.66655,16.9863934 3.68735,16.8475738 C4.55928333,16.7291967 5.77825,16.1491967 6.64003333,15.4931311 C6.72655,15.5891639 6.81838333,15.6794918 6.91263333,15.7660164 C6.08855,17.1166557 4.15473333,17.6709836 3.52446667,17.721377 C3.49401667,17.7242295 3.47613333,17.7556066 3.49063333,17.7808033 C3.90436667,18.4962951 4.8372,18.734 5.85655,18.2452787 C6.46265,17.9538525 7.21616667,17.1908197 7.73381667,16.3341311 C7.85271667,16.3926066 7.97645,16.4420492 8.1026,16.4857869 C7.78166667,18.0993279 6.17796667,19.0839016 5.89763333,19.2450656 C5.87588333,19.2574262 5.87056667,19.2864262 5.887,19.3049672 C6.36405,19.8417049 7.4646,19.8526393 8.13836667,19.0762951 C8.5521,18.5985082 8.87013333,17.710918 9.04848333,16.6393443 C9.54438333,16.6393443 10.6768333,16.8523279 11.0552833,17.8549672 C11.0717167,17.8972787 11.1389,17.8863443 11.1389,17.8421311 L11.1389,15.0956885 C11.1389,15.0676393 11.1094167,15.0490984 11.0813833,15.0581311 C10.45885,15.2639836 9.8107,15.2891803 9.36216667,15.2021803 C8.47815,15.0457705 7.8097,14.3245738 7.8097,13.4574262 C7.8097,12.9587213 8.03155,12.5089836 8.38728333,12.1861803 C8.46316667,12.1181967 8.45301667,12.0031475 8.36505,11.9494262 C8.323,11.9242295 8.28143333,11.8985574 8.25001667,11.8785902 C5.16248333,9.91609836 2.34996667,5.37118033 2.04691667,4.872 C2.0329,4.84870492 1.99906667,4.84395082 1.97828333,4.86201639 C1.0295,5.69731148 0.937183333,7.33414754 1.93575,8.61727869 C2.59646667,9.46636066 3.98363333,10.3948361 5.40415,11.2006557 C5.38433333,11.3504098 5.37031667,11.5011148 5.36306667,11.6537213 C2.43986667,11.0261803 0.58435,9.0094918 0.286133333,8.66719672 C0.266316667,8.64390164 0.226683333,8.64865574 0.21315,8.67527869 C-0.3248,9.73116393 0.1421,11.1488361 1.20881667,11.7430984 C2.14551667,12.2641475 3.61533333,12.5707869 5.42348333,12.7870984 C5.4433,12.9178361 5.4665,13.0485738 5.49501667,13.1783607 C2.7811,13.545377 0.6612,12.5541475 0.296766667,12.3696885 C0.2697,12.3559016 0.236833333,12.3730164 0.23345,12.401541 C0.0961833333,13.5311148 0.8091,14.4381967 2.0271,14.6392951 C3.25235,14.8418197 5.83915,14.2304426 5.83915,14.2304426 Z M22.66205,22.709377 L21.71955,21.9677377 C21.3435167,22.1916557 21.06705,22.5472623 20.95975,22.9641967 C20.3928,23.0435902 18.8471,22.7003443 18.9974167,22.472623 C20.6915,20.0898689 19.3956833,18.6712459 17.8383833,18.7501639 L17.8383833,20.3503934 C17.8383833,20.8643115 17.38985,21.2807705 16.8374,21.2807705 L15.7619833,21.2807705 C14.9905833,21.2807705 14.4884,22.0561639 14.4884,22.0561639 C14.4884,22.0561639 13.9862167,21.2807705 13.2148167,21.2807705 L12.1394,21.2807705 C11.5864667,21.2807705 11.1389,20.8643115 11.1389,20.3503934 L11.1389,18.7501639 C9.5816,18.6712459 8.28481667,20.0898689 9.97938333,22.472623 C10.12825,22.6979672 8.53953333,23.0588033 7.79423333,22.9675246 C7.598,22.7640492 7.31476667,22.6356885 6.9977,22.6356885 C6.85801667,22.6356885 6.7251,22.6613607 6.60281667,22.7065246 C6.60281667,22.7065246 3.6743,19.9339344 3.62065,19.9068361 L3.64481667,19.8507377 C3.81156667,19.5388689 3.55636667,19.1989508 3.39493333,19.2227213 C3.58246667,18.9978525 3.59116667,18.0132787 2.55103333,17.7855574 C2.58148333,17.9833279 2.59695,18.3869508 2.59695,18.3869508 C2.59695,18.3869508 1.79413333,17.9529016 1.39103333,18.3275246 C1.03675,18.7468361 1.5283,19.5074918 1.5283,19.5074918 C1.5283,19.5074918 1.11746667,19.5174754 0.91495,19.5003607 C1.21268333,20.5072787 2.21125,20.4359672 2.4273,20.2372459 C2.41328333,20.397459 2.77433333,20.6256557 3.08028333,20.442623 L3.21465,20.3774918 C3.23833333,20.4093443 6.09048333,23.1039672 6.09048333,23.1039672 C5.9595,23.2984098 5.89715,23.5370656 5.94016667,23.7914098 C6.00783333,24.1888525 6.33891667,24.5183115 6.76183333,24.6038852 C7.06053333,24.6637869 7.34135,24.6057869 7.56658333,24.4740984 L8.32155,25.1748525 C8.38873333,25.2357049 8.4796,25.2737377 8.5811,25.2666066 C8.76573333,25.2542459 8.90396667,25.1044918 8.88995,24.9328689 C8.88415,24.855377 8.84451667,24.7888197 8.7899,24.7384262 C8.77781667,24.7251148 8.02091667,24.022459 8.02091667,24.022459 C8.64538333,23.5846066 9.80876667,23.2760656 10.7744667,23.2760656 C10.9441167,23.2760656 11.0238667,23.1324918 10.9653833,22.9917705 C10.5279667,21.9396885 11.4685333,21.1776066 12.4414833,21.7980164 C12.86585,22.0685246 13.2969833,22.601459 13.6217833,23.4904754 C12.0253333,23.8769836 10.02095,24.9419016 9.61543333,26.1042787 C9.45931667,26.5530656 9.97503333,27.164918 10.6014333,27.2880492 C10.6251167,27.2932787 10.6478333,27.2775902 10.6521833,27.2552459 C10.9794,25.52 12.84555,24.2268852 13.8165667,24.0072459 C13.8653833,24.1379836 13.8494333,24.0956721 13.89825,24.2259344 C12.8407167,24.7260656 11.8150833,25.781 11.5221833,27.0351311 C11.3878167,27.6094262 12.0282333,28.1271475 12.557,28.2688197 C12.5835833,28.2759508 12.6096833,28.2574098 12.6111333,28.2317377 C12.7116667,26.6457705 13.4120167,25.2989344 14.0393833,24.6861311 C14.0563,24.8040328 14.06935,24.9247869 14.07805,25.0469672 C14.07805,25.0469672 13.4357,26.8368852 13.4357,28.1428361 C13.4357,28.7504098 14.3385667,29.1744754 14.4719667,29.2339016 C14.6387167,29.1744754 15.5411,28.7504098 15.5411,28.1428361 C15.5411,26.8368852 14.89875,25.0469672 14.89875,25.0469672 C14.9079333,24.9247869 14.9205,24.8040328 14.9379,24.6861311 C15.5647833,25.2989344 16.2656167,26.6452951 16.3656667,28.2312623 C16.3671167,28.2569344 16.3937,28.2759508 16.4198,28.2688197 C16.94905,28.1271475 17.5889833,27.6094262 17.4551,27.0351311 C17.1617167,25.781 16.1365667,24.7260656 15.0790333,24.2259344 C15.1273667,24.0956721 15.1114167,24.1379836 15.1602333,24.0072459 C16.1317333,24.2268852 17.9974,25.52 18.3246167,27.2552459 C18.3289667,27.2775902 18.3521667,27.2932787 18.3753667,27.2880492 C19.0012833,27.164918 19.5179667,26.5530656 19.3608833,26.1042787 C18.9563333,24.9419016 16.9514667,23.8769836 15.3550167,23.4904754 C15.6803,22.601459 16.1114333,22.0685246 16.5358,21.7980164 C17.5082667,21.1776066 18.4488333,21.9396885 18.0114167,22.9917705 C17.9529333,23.1324918 18.0322,23.2760656 18.2023333,23.2760656 C19.2946667,23.2760656 20.6402667,23.6706557 21.1729,24.1997869 C21.5131667,24.710377 22.1419833,25.0369836 22.8515167,24.9670984 C23.6577167,24.8881803 24.31505,24.2825082 24.4059167,23.5337377 C24.4851833,22.8776721 24.1458833,22.2886393 23.6050333,21.9677377 L22.66205,22.709377 Z M15.7151,17.930082 C16.0510167,17.8055246 16.5773667,17.9063115 16.5594833,18.3912295 C16.5551333,18.5010492 16.7093167,18.5010492 16.7204333,18.3888525 C16.8209667,17.6629016 16.3303833,17.4537213 15.8170833,17.5388197 C15.7532833,17.2892295 15.7010833,17.0710164 15.6416333,16.8547049 C15.5942667,16.6797541 15.5768667,16.3512459 15.7793833,16.3512459 C15.8886167,16.3512459 15.8446333,16.6569344 15.8344833,16.788623 C15.8253,16.9041475 15.8668667,16.9740328 15.9606333,16.9773607 C16.0191167,16.9797377 16.0921,16.9050984 16.1356,16.8556557 C16.4294667,16.5233443 16.4976167,16.0089508 16.1534833,15.7607869 C15.8654167,15.5525574 15.1442833,15.707541 14.9461167,16.0041967 C14.91615,15.8924754 14.7730833,15.7080164 14.70445,15.6276721 C14.63775,15.5492295 14.62035,15.4955082 14.7126667,15.4265738 C14.7561667,15.3932951 14.8876333,15.2625574 14.8876333,15.127541 C14.8876333,15.0476721 14.8257667,14.9002951 14.62905,14.9002951 C14.4739,14.9002951 14.30135,15.0077377 14.30135,15.2473443 C14.30135,15.3005902 14.3144,15.3576393 14.3487167,15.4189672 C14.2506,15.4028033 13.9842833,15.409459 13.8475,15.4432131 L15.7387833,20.6332623 C16.2801167,20.366082 16.6769333,19.9429672 16.6769333,19.4889508 C16.6769333,19.1019672 16.1070833,19.2303279 15.8301333,19.5322131 C15.7412,19.0415902 15.6619333,18.5885246 15.5754167,18.1368852 C15.5517333,18.0123279 15.61505,17.9676393 15.7151,17.930082 Z M13.0408167,14.4044426 L13.4381167,15.5083443 C13.09785,15.5891639 12.5507167,15.8373279 12.5507167,16.1658361 C12.5507167,16.6032131 13.3245333,16.8879836 13.7721,16.8537541 C13.7498667,16.9535902 13.7754833,17.0424918 13.8450833,17.1237869 C13.6826833,17.1237869 13.37625,17.199377 13.2757167,17.3077705 C13.0384,17.0867049 12.6672,17.0063607 12.4907833,17.1409016 C12.3134,17.2763934 12.3080833,17.5060164 12.4932,17.7655902 C12.62225,17.9452951 12.6705833,18.122623 12.5255833,18.3308525 C13.0649833,18.3308525 12.8663333,17.629623 13.07755,17.629623 C13.05,17.7655902 13.0669167,17.9229508 13.1283,18.0974262 C13.1689,18.2134262 13.1689,18.2956721 13.0993,18.4073934 C12.9253,18.6855082 12.6546333,19.324459 12.6913667,19.902082 C12.5144667,19.9011311 12.4245667,19.8578689 12.4869167,19.6163607 C12.5101167,19.5265082 12.4545333,19.4623279 12.3810667,19.5730984 C12.2998667,19.6952787 12.2607167,19.9039836 12.2607167,19.9933607 C12.2607167,20.5077541 12.8735833,20.6113934 13.1075167,20.5025246 C13.7841833,21.1573633 15.11335,20.9826885 15.5585,20.7630492 L13.2182,14.3416885 C13.17035,14.220459 12.9987667,14.278459 13.0408167,14.4044426 Z M12.9596167,19.6938525 C12.9112833,19.4295246 13.2791,18.9569672 13.7469667,18.5010492 C13.6474,18.7981803 13.7092667,19.3101967 13.9045333,19.4865738 C13.5652333,19.4865738 13.1621333,19.5502787 12.9596167,19.6938525 L12.9596167,19.6938525 Z'/%3E%3C/svg%3E");
    margin: auto;
  }
  .stamp-title
  {
    font-size: medium;
    font-weight: bold;
    text-align: center;
    text-transform: uppercase;
    margin: auto;
  }
        </xsl:text>
      </style>
  </xsl:template>
</xsl:stylesheet>
