<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0.0">

  <!-- Регистрационные отметки документа -->
  <xsl:template mode="РегистрацияДокумента" match="*[local-name()='Документ']">
    <xsl:variable name="ТребуетРегистрации" select="./*[local-name()='ДанныеДокумента']
      /*[local-name()='ЗаголовокДокумента']
      /*[local-name()='ТребуетРегистрации']"/>
    <xsl:if test="$ТребуетРегистрации='Да'">
      <div class="textAttention textHeader2">
        <xsl:text>Регистрация:</xsl:text>
      </div>
    </xsl:if>

    <xsl:choose>
      <xsl:when test="./*[local-name()='РегистрацияДокумента']/*[local-name()='НаправлениеИсходящего']">
        <xsl:for-each select="./*[local-name()='РегистрацияДокумента']/*[local-name()='НаправлениеИсходящего']">
          <div class="textAttention">
            <xsl:text>Исх. № </xsl:text>
            <xsl:value-of select=".//*[local-name()='НомерРегистрации']"/>
            <xsl:text> от </xsl:text>
            <xsl:call-template name="ДатаПрописью">
              <xsl:with-param name="Дата" select=".//*[local-name()='ДатаРегистрации']"/>
            </xsl:call-template>
            <xsl:text> - </xsl:text>
            <xsl:value-of select=".//*[local-name()='ОрганРегистрации']/@*[local-name()='Представление']"/>
          </div>
        </xsl:for-each>
        <br/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:if test="$ТребуетРегистрации='Да'">
          <div class="textInformation">
            <xsl:text>Документ ещё не зарегистрирован</xsl:text>
          </div>
          <br/>
        </xsl:if>
      </xsl:otherwise>
    </xsl:choose>

    <xsl:choose>
      <xsl:when test="./*[local-name()='РегистрацияДокумента']/*[local-name()='СнятиеПометкиСЭкземпляра']">
        <xsl:for-each select="./*[local-name()='РегистрацияДокумента']/*[local-name()='СнятиеПометкиСЭкземпляра']">
          <div class="textInformation">
            <xsl:text>Документ содержал сведения ДСП, пометка снята </xsl:text>
            <xsl:call-template name="ДатаПрописью">
              <xsl:with-param name="Дата" select="substring-before(./*[local-name()='ИнформацияОСобытии']/*[local-name()='ВремяСобытия'], 'T')"/>
            </xsl:call-template>
          </div>
        </xsl:for-each>
        <br/>
      </xsl:when>
      <xsl:when test="./*[local-name()='РегистрацияДокумента']/*[local-name()='ОграничениеДоступа']">
        <div class="textWarning">
          <xsl:text>Документ содержит сведения ДСП (для служебного пользования)</xsl:text>
        </div>
        <br/>
      </xsl:when>
    </xsl:choose>
  </xsl:template>

</xsl:stylesheet>
